package autohost_grafana

import (
	"bytes"
	"os"
	"text/template"
)

type DashboardTemplateParams struct {
	ID              int
	Title           string
	UID             string
	Panels          string
	Region          string
	DataSourceRegex string
	StageVariable   string
	SubStageVariable   string

}

func WriteDashboardToFile(filePath string, params *DashboardTemplateParams) error {
	dashTemp, err := template.New("DashboardPanelTemplate").Parse(DashboardTemplate)
	if err != nil {
		return err
	}

	var b bytes.Buffer
	err = dashTemp.Execute(&b, params)
	if err != nil {
		return err
	}

	err = os.WriteFile(filePath, b.Bytes(), 0644)
	if err != nil {
		return err
	}

	return nil
}
var DashboardTemplate = `
{
  "annotations": {
    "list": [
      {
        "builtIn": 1,
        "datasource": "-- Grafana --",
        "enable": true,
        "hide": true,
        "iconColor": "rgba(0, 211, 255, 1)",
        "name": "Annotations & Alerts",
        "type": "dashboard"
      }
    ]
  },
  "editable": true,
  "gnetId": null,
  "graphTooltip": 0,
  "id": {{.ID}},
  "iteration": 1583189151530,
  "links": [
    {
      "icon": "external link",
      "tags": [],
      "title": "Generated using live/autohost-grafana",
      "type": "link",
      "url": "https://git.xarth.tv/live/autohost-grafana"
	}
  ],
  "panels": {{.Panels}},
  "refresh": "1m",
  "schemaVersion": 22,
  "style": "dark",
  "tags": [],
  "templating": {
    "list": [
      {
        "current": {
          "text": "twitch-ce-host-aws 447680546588",
          "value": "twitch-ce-host-aws 447680546588"
        },
        "hide": 0,
        "includeAll": false,
        "label": null,
        "multi": false,
        "name": "account",
        "options": [],
        "query": "cloudwatch",
        "refresh": 1,
        "regex": "{{.DataSourceRegex}}",
        "skipUrlSync": false,
        "type": "datasource"
      },
      {
        "current": {
          "selected": true,
          "text": "us-west-2",
          "value": "us-west-2"
        },
        "hide": 2,
        "label": null,
        "name": "region",
        "options": [
          {
            "selected": true,
            "text": "us-west-2",
            "value": "us-west-2"
          }
        ],
        "query": "us-west-2",
        "skipUrlSync": false,
        "type": "constant"
      },
      {{.StageVariable}},
	  {{.SubStageVariable}}
    ]
  },
  "time": {
    "from": "now-1h",
    "to": "now"
  },
  "timepicker": {
    "refresh_intervals": [
      "5s",
      "10s",
      "30s",
      "1m",
      "5m",
      "15m",
      "30m",
      "1h",
      "2h",
      "1d"
    ]
  },
  "timezone": "",
  "title": "{{.Title}}",
  "uid": "{{.UID}}",
  "version": 12
}
`
