package autohost_grafana

type Panel interface {
	SetDashboardProps(id, x, y int)
	GetWidth() int
	GetHeight() int
}

type GrafanaPanel struct {
	DataSource  *string        `json:"datasource"`
	GridPos     GrafanaGridPos `json:"gridPos"`
	ID          int            `json:"id"`
	Type        string         `json:"type"`
	Transparent *bool          `json:"transparent,omitempty"`
}

type GrafanaGridPos struct {
	H int `json:"h"`
	W int `json:"w"`
	X int `json:"x"`
	Y int `json:"y"`
}

func (p *GrafanaPanel) GetHeight() int {
	return p.GridPos.H
}

func (p *GrafanaPanel) GetWidth() int {
	return p.GridPos.W
}

func (p *GrafanaPanel) SetDashboardProps(id, x, y int) {
	p.ID = id
	p.GridPos.X = x
	p.GridPos.Y = y
}

type GrafanaGraphPanel struct {
	*GrafanaPanel
	AliasColors     map[string]string       `json:"aliasColors"`
	Bars            bool                    `json:"bars"`
	DashLength      int                     `json:"dashLength"`
	Dashes          bool                    `json:"dashes"`
	Description     string                  `json:"description"`
	Fill            int                     `json:"fill"`
	FillGradient    int                     `json:"fillGradient"`
	HiddenSeries    bool                    `json:"hiddenSeries"`
	Legend          GrafanaLegend           `json:"legend"`
	Lines           bool                    `json:"lines"`
	LineWidth       int                     `json:"linewidth"`
	NullPointMode   string                  `json:"nullPointMode"`
	Options         GrafanaPanelOptions     `json:"options"`
	Percentage      bool                    `json:"percentage"`
	PointRadius     float64                 `json:"pointradius"`
	Points          bool                    `json:"points"`
	Renderer        string                  `json:"renderer"`
	RepeatDirection string                  `json:"repeatDirection"`
	SeriesOverrides []GrafanaSeriesOverride `json:"seriesOverrides"`
	SpaceLength     int                     `json:"spaceLength"`
	Stack           bool                    `json:"stack"`
	SteppedLine     bool                    `json:"steppedLine"`
	Targets         []GrafanaTarget         `json:"targets"`
	Threshold       []GrafanaThreshold      `json:"thresholds"`
	TimeFrom        *string                 `json:"timeFrom"`
	TimeRegions     []GrafanaTimeRegion     `json:"timeRegions"`
	TimeShift       *string                 `json:"timeShift"`
	Title           string                  `json:"title"`
	Tooltip         GrafanaTooltip          `json:"tooltip"`
	XAxis           GrafanaXAxis            `json:"xaxis"`
	YAxes           []GrafanaYAxesItem      `json:"yaxes"`
	YAxis           GrafanaYAxis            `json:"yaxis"`
}

var _ Panel = &GrafanaGraphPanel{}

type GrafanaRowPanel struct {
	*GrafanaPanel
	Collapsed bool    `json:"collapsed"`
	Panels    []Panel `json:"panels"`
	Title     string  `json:"title"`
}

type GrafanaTextPanel struct {
	*GrafanaPanel
	Content   string            `json:"content"`
	Mode      string            `json:"mode"`
	Options   map[string]string `json:"options"`
	TimeFrom  *string           `json:"timeFrom"`
	TimeShift *string           `json:"timeShift"`
	Title     string            `json:"title"`
}

type GrafanaLegend struct {
	AlignAsTable bool  `json:"alignAsTable"`
	Avg          bool  `json:"avg"`
	Current      bool  `json:"current"`
	Max          bool  `json:"max"`
	Min          bool  `json:"min"`
	Show         bool  `json:"show"`
	Total        bool  `json:"total"`
	Values       bool  `json:"values"`
	RightSide    *bool `json:"rightSide,omitempty"`
}

type GrafanaPanelOptions struct {
	DataLinks []string `json:"dataLinks"`
}

type GrafanaSeriesOverride struct {
	Alias string `json:"alias"`
	YAxis int    `json:"yaxis"`
}

type GrafanaTarget struct {
	Alias      string            `json:"alias"`
	Dimensions map[string]string `json:"dimensions"`
	Expression string            `json:"expression"`
	Hide       bool              `json:"hide"`
	ID         string            `json:"id"`
	MatchExact bool              `json:"matchExact"`
	MetricName string            `json:"metricName"`
	Namespace  string            `json:"namespace"`
	RefID      string            `json:"refId"`
	Region     string            `json:"region"`
	Statistics []string          `json:"statistics"`
}

type GrafanaThreshold struct{}

type GrafanaTimeRegion struct{}

type GrafanaTooltip struct {
	Shared    bool   `json:"shared"`
	Sort      int    `json:"sort"`
	ValueType string `json:"value_type"`
}

type GrafanaXAxis struct {
	Buckets []string `json:"buckets"`
	Mode    string   `json:"mode"`
	Name    *string  `json:"name"`
	Show    bool     `json:"show"`
	Values  []string `json:"values"`
}

type GrafanaYAxesItem struct {
	Format  string  `json:"format"`
	Label   *string `json:"label"`
	LogBase int     `json:"logBase"`
	Max     *string `json:"max"`
	Min     *string `json:"min"`
	Show    bool    `json:"show"`
}

type GrafanaYAxis struct {
	Align      bool    `json:"align"`
	AlignLevel *string `json:"alignLevel"`
}

type CustomGrafanaVariable struct {
	AllValue *string `json:"allValue"`
	// TODO: Fix this
	Current GrafanaVariableOption `json:"current"`
	Hide int `json:"hide"`
	IncludeAll bool `json:"includeAll"`
	Label  *string `json:"label"`
	Multi bool `json:"multi"`
	Name string `json:"name"`
	Options []GrafanaVariableOption `json:"options"`
	Query string `json:"query"`
	SkipUrlSync bool `json:"skipUrlSync"`
	Type string `json:"type"`
}

type GrafanaVariableOption struct {
	Selected bool `json:"selected"`
	Text string `json:"text"`
	Value string `json:"value"`
}