package autohost_grafana

import "fmt"

const (
	DashboardWidth    = 24
	GraphHeight       = 8
	GraphWidthHalf    = DashboardWidth / 2
	GraphWidthQuarter = DashboardWidth / 4
	GraphWidthThird   = DashboardWidth / 3
)

const (
	StatAverage     = "Average"
	StatP50         = "p50"
	StatP90         = "p90"
	StatP99         = "p99"
	StatP999        = "p99.9"
	StatSampleCount = "SampleCount"
	StatSum         = "Sum"
)

const (
	PanelTypeGraph = "graph"
	PanelTypeRow   = "row"
	PanelTypeText  = "text"
)

const RegionDefault = "default"

var EmptyDimensions = make(map[string]string, 0)

func NewGrafanaGraphPanel() GrafanaGraphPanel {
	return GrafanaGraphPanel{
		GrafanaPanel: &GrafanaPanel{
			GridPos:    GrafanaGridPos{},
			ID:         0,
			Type:       PanelTypeGraph,
			DataSource: nil,
		},
		AliasColors:  make(map[string]string, 0),
		Bars:         false,
		DashLength:   10,
		Dashes:       false,
		Description:  "",
		Fill:         0,
		FillGradient: 0,

		HiddenSeries: false,
		Legend: GrafanaLegend{
			AlignAsTable: true,
			Avg:          true,
			Current:      true,
			Max:          true,
			Min:          true,
			Show:         true,
			Total:        false,
			Values:       true,
		},
		Lines:         true,
		LineWidth:     1,
		NullPointMode: "null",
		Options: GrafanaPanelOptions{
			DataLinks: make([]string, 0),
		},
		Percentage:      false,
		PointRadius:     0.5,
		Points:          false,
		Renderer:        "flot",
		RepeatDirection: "h",
		SeriesOverrides: make([]GrafanaSeriesOverride, 0),
		SpaceLength:     10,
		Stack:           false,
		SteppedLine:     false,
		Targets:         make([]GrafanaTarget, 0),
		Threshold:       make([]GrafanaThreshold, 0),
		TimeFrom:        nil,
		TimeRegions:     make([]GrafanaTimeRegion, 0),
		TimeShift:       nil,
		Title:           "",
		Tooltip: GrafanaTooltip{
			Shared:    true,
			Sort:      0,
			ValueType: "individual",
		},

		XAxis: GrafanaXAxis{
			Buckets: nil,
			Mode:    "time",
			Name:    nil,
			Show:    true,
			Values:  make([]string, 0),
		},
		YAxes: []GrafanaYAxesItem{
			{
				Format:  "s",
				Label:   nil,
				LogBase: 1,
				Max:     nil,
				Min:     nil,
				Show:    true,
			}, {
				Format:  "s",
				Label:   nil,
				LogBase: 1,
				Max:     nil,
				Min:     nil,
				Show:    false,
			},
		},
		YAxis: GrafanaYAxis{
			Align:      false,
			AlignLevel: nil,
		},
	}
}

func RateExpression(sumTargetID string) string {
	return fmt.Sprintf("%s/PERIOD(%s)", sumTargetID, sumTargetID)
}

type RowPanelArgs struct {
	Collapsed bool
	ID        int
	Title     string
	X         int
	Y         int
}

func NewRowPanel(args RowPanelArgs) GrafanaRowPanel {
	return GrafanaRowPanel{
		GrafanaPanel: &GrafanaPanel{
			ID: args.ID,
			GridPos: GrafanaGridPos{
				H: 1,
				W: DashboardWidth,
				X: args.X,
				Y: args.Y,
			},
			Type: PanelTypeRow,
		},
		Collapsed: args.Collapsed,
		Panels:    make([]Panel, 0),
		Title:     args.Title,
	}
}

type TextPanelArgs struct {
	Content     string
	ID          int
	Title       string
	Transparent bool
	W           int
	H           int
	X           int
	Y           int
}

func NewTextPanel(args TextPanelArgs) GrafanaTextPanel {
	var transparentPtr *bool
	if args.Transparent {
		transparentPtr = BoolPtr(args.Transparent)
	}

	return GrafanaTextPanel{
		GrafanaPanel: &GrafanaPanel{
			ID: args.ID,
			GridPos: GrafanaGridPos{
				H: args.H,
				W: args.W,
				X: args.X,
				Y: args.Y,
			},
			Transparent: transparentPtr,
			Type:        PanelTypeText,
		},
		Content:   args.Content,
		Mode:      "markdown",
		Options:   make(map[string]string, 0),
		TimeFrom:  nil,
		TimeShift: nil,
		Title:     args.Title,
	}
}

type PlaceholderPanelArgs struct {
	W int
	H int
}

func NewPlaceholderPanel(args PlaceholderPanelArgs) GrafanaTextPanel {
	return NewTextPanel(TextPanelArgs{
		H:           args.H,
		W:           args.W,
		Transparent: true,
	})
}

func StrPtr(s string) *string {
	return &s
}

func BoolPtr(b bool) *bool {
	return &b
}
