# CDK README

This folder contains definitions for Autohost AWS infrastructure managed with 
[AWS Cloud Development Kit](https://docs.aws.amazon.com/cdk/latest/guide/home.html).

The `cdk.json` file tells the CDK Toolkit how to execute your app.

## Quick commands

 * `npm run build`                    compile typescript to Javascript.
 * `npm run watch`                    watch for changes and compile.
 * `npm run clean`                    delete the generated Javascript.
 * `npx cdk synth`                    emits the synthesized CloudFormation template 
 * `npx cdk ls`                       lists the stacks that this CDK app manages
 * `npx cdk synth [STACK_NAME]`       emits the synthesized CloudFormation template for a particular stack. 
 * `npx cdk deploy [STACK_NAME]`      deploy this stack to your default AWS account/region
 * `npx cdk diff [STACK_NAME]`        compare deployed stack with current state
 
## Workflow

  1. Add constructs to generate the AWS resources that we need.
  2. Run `npm run build` to verify that the Typescript compiles to Javascript.
  3. Run `npx cdk synth` to generate CloudFormation templates for each `Stack` in `bin/cdk.ts`.
  4. Run `npx cdk diff [STACK_NAME]` to inspect the changes that will be made.
  5. Run `npx cdk deploy [STACK_NAME]` to perform a CloudFormation update for the specified stack.

