import * as cdk from "@aws-cdk/core";
import {
  AttributeType,
  BillingMode,
  StreamViewType,
  Table,
} from "@aws-cdk/aws-dynamodb";

export interface DynamoDBStackProps extends cdk.StackProps {}

/**
 * DynamoDBStack creates a stack for our DynamoDB tables.
 */
export class DynamoDBStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: DynamoDBStackProps) {
    super(scope, id, props);

    // Create DynamoDB for auto-hosting settings.
    new Table(this, "SettingsTable", {
      billingMode: BillingMode.PAY_PER_REQUEST,
      partitionKey: {
        name: "ChannelID",
        type: AttributeType.STRING,
      },
      pointInTimeRecovery: true,
      replicationRegions: ["us-east-2"],
      stream: StreamViewType.NEW_AND_OLD_IMAGES,
    });
  }
}
