import * as cdk from "@aws-cdk/core";
import {Alarms} from "../memcached/alarms";
import {EnvName} from "../../env-names";
import {AlarmSNSTopics} from "../metrics/alarm-sns-topics";

export interface MemcachedStackProps extends cdk.StackProps {
    readonly envName: EnvName;
    readonly clusterName: string;
    readonly numNodes: number;
    readonly cloudwatchAlarmSNSTopics: AlarmSNSTopics;
    readonly alarmTwitchSeverity: number;
}

/**
 * MemcachedStack creates a memcached Cloudwatch alarms for the cluster.
 */
export class MemcachedStack extends cdk.Stack {
    constructor(scope: cdk.Construct, id: string, props: MemcachedStackProps) {
        super(scope, id, props);

        // Create Cloudwatch alarms for the Memcached cluster.
        new Alarms(this, "Alarms", {
            envName: props.envName,
            clusterName: props.clusterName,
            numNodes: 3,
            cloudwatchAlarmSNSTopics: props.cloudwatchAlarmSNSTopics,
            twitchSeverity: props.alarmTwitchSeverity
        });
    }
}