import * as cdk from "@aws-cdk/core";
import {CommonServiceProps, createDefaultAlarmsForApi} from "../shared";
import {Duration} from "@aws-cdk/core";


export class RaidsAPIAlarms extends cdk.Construct {

    constructor(scope: cdk.Construct, id: string, serviceProps: CommonServiceProps) {
        super(scope, id);

        createDefaultAlarmsForApi(scope, "IsRaidValid", serviceProps, Duration.seconds(.05), 3);
    }
}