import * as cdk from "@aws-cdk/core";
import {EnvName} from "../../env-names";
import {AlarmSNSTopics} from "../metrics/alarm-sns-topics";
import {RaidsAPIAlarms} from "./alarms";

export interface RaidsStackProps extends cdk.StackProps {
    readonly environmentName: EnvName;
    readonly cloudwatchAlarmSNSTopics: AlarmSNSTopics;
}


export class RaidsStack extends cdk.Stack {
    constructor(scope: cdk.Construct, id: string, props: RaidsStackProps) {
        super(scope, id, props);

        const stack = cdk.Stack.of(this);

        // Create the alarms for each raids api
        new RaidsAPIAlarms(this, "RaidsAPIAlarms", {
            environmentName: props.environmentName,
            cloudwatchAlarmSNSTopics: props.cloudwatchAlarmSNSTopics,
            region: stack.region,
            serviceName: "Autohost Server",
        });
    }
}

