import * as cdk from "@aws-cdk/core";
import { StringParameter } from "@aws-cdk/aws-ssm";

export interface WorkerSSMParamtersProps {
  readonly keyPrefix: string;
}

interface SSMParameterArgs {
  readonly constructID: string;
  readonly keySuffix: string;
  readonly value: string;
}

/**
 * WorkerSSMParamters creates SSM parameters that Autohost Worker uses for dynamic configuration.
 */
export class WorkerSSMParamters extends cdk.Construct {
  constructor(
    scope: cdk.Construct,
    id: string,
    props: WorkerSSMParamtersProps
  ) {
    super(scope, id);

    const args: SSMParameterArgs[] = [
      {
        constructID: "AutohostWorkerDisableAutohostingParam",
        keySuffix: "AutohostWorker/DisableAutohosting",
        value: "false",
      },
      {
        constructID: "AutohostWorkerNumClueGoroutinesParam",
        keySuffix: "AutohostWorker/NumClueGoroutines",
        value: "119",
      },
    ];

    for (let a of args) {
      this.addParam(a, props.keyPrefix);
    }
  }

  private addParam(args: SSMParameterArgs, keyPrefix: string) {
    const parameterName = "/" + keyPrefix + "/" + args.keySuffix;
    new StringParameter(this, args.constructID, {
      parameterName,
      stringValue: args.value,
    });
  }
}
