import * as cdk from "@aws-cdk/core";
import { Repository } from "@aws-cdk/aws-ecr";

interface RepoProps {
  readonly constructID: string;
  readonly repositoryName: string;
}

export class DependencyECRRepositories extends cdk.Construct {
  constructor(scope: cdk.Construct, id: string) {
    super(scope, id);

    const repoProps: RepoProps[] = [
      {
        constructID: "AmazonLinux",
        repositoryName: "amazonlinux",
      },
      {
        constructID: "DynamoDBLocal",
        repositoryName: "dynamodb-local",
      },
      {
        constructID: "Golang",
        repositoryName: "golang",
      },
      {
        constructID: "Memcached",
        repositoryName: "memcached",
      },
      {
        constructID: "Redis",
        repositoryName: "redis",
      },
      {
        constructID: "SonarScannerCLI",
        repositoryName: "sonar-scanner-cli",
      },
    ];

    for (let r of repoProps) {
      new Repository(this, r.constructID, {
        repositoryName: r.repositoryName,
        removalPolicy: cdk.RemovalPolicy.DESTROY,
        lifecycleRules: [
          {
            maxImageCount: 10,
          },
        ],
      });
    }
  }
}
