package main

import (
	"log"

	"code.justin.tv/common/twitchhttp"
	"code.justin.tv/live/autohost/internal/api"
	"code.justin.tv/live/autohost/internal/hosting"
)

func main() {
	hostingComponents, err := hosting.NewHostingComponents(nil)
	if err != nil {
		log.Fatalf("failed to create hosting components: %+v", err)
	}

	handler, err := api.NewServer(hostingComponents)
	if err != nil {
		log.Fatal(err)
	}

	err = twitchhttp.ListenAndServe(handler, &twitchhttp.ServerConfig{})
	log.Fatal(err)
}
