package main

import (
	"os"

	"code.justin.tv/creator-collab/log"
	"code.justin.tv/creator-collab/log/errors"
	"code.justin.tv/live/autohost/internal/hosting/config"
	"code.justin.tv/live/autohost/internal/localdynamo"
)

// Creates the local DynamoDB tables that Autohost expects.
// This is meant to help a developer to set up an environment for local
// development.
func main() {
	logger := log.NewDevelopmentLogger()

	config, err := config.GetConfig()
	if err != nil {
		logger.Error(err)
		os.Exit(1)
	}

	localEndpoint := config.DynamoDB.LocalDynamoEndpoint
	tables, err := localdynamo.NewLocalDynamoTables(localEndpoint, logger)
	if err != nil {
		logger.Error(errors.Wrap(err, "initializing local dynamodb table utility failed", errors.Fields{
			"local_dynamo_endpoint": localEndpoint,
		}))
		os.Exit(1)
	}

	err = tables.Create()
	if err != nil {
		logger.Error(errors.Wrap(err, "creating new local dynamodb tables failed", errors.Fields{
			"local_dynamo_endpoint": localEndpoint,
		}))
		os.Exit(1)
	}
}
