package main

import (
	"log"
	"os"
	"syscall"

	"os/signal"

	"code.justin.tv/live/autohost/internal/worker"
)

func main() {
	w, err := worker.New()
	if err != nil {
		log.Fatalf("creating worker failed: %+v", err)
	}

	w.Start()
	go triggerShutdown(w)

	err = w.Wait()
	if err != nil {
		log.Fatalf("worker component failed: %+v", err)
	}
}

func triggerShutdown(worker *worker.Worker) {
	// Wait for the process to receive a signal to exit.
	sigChan := make(chan os.Signal, 1)
	signal.Notify(sigChan, syscall.SIGINT, syscall.SIGTERM, syscall.SIGUSR2)
	<-sigChan

	// Signal components to stop.
	worker.Stop()
}
