# GraphQL end to end tests

These tests verify that the Autohost GraphQL operations work end to end.
They are meant to help with migrating Autohost from Autohost Server to TwitchNexus.

## Set up

Install dependencies:
```
npm install
```

## Usage

Run the test, passing in configuration using environment variables.

```
GQL_URL="https://dev-graphql.twitch.a2z.com/wanjocel/VXCHAN-486/gql" \
USER_ID="1111111111" \
OAUTH_TOKEN="OAuth meowmeowmeowmeowmeowmeow" \
npm run test
```

  * `GQL_URL`: The address of the GraphQL server, e.g. "https://dev-graphql.twitch.a2z.com/wanjocel/VXCHAN-486/gql\"
  * `USER_ID`: The tests manipulate this user's autohost list and settings. Be careful when using users that you don't own.
  * `OAUTH_TOKEN`: This should be the OAuth token of the test user. E.g. "OAuth jidjdgjdjdgjdfijdfj"
