package api

import (
	"context"
	"net/http/httptest"
	"testing"
	"time"

	"code.justin.tv/foundation/twitchclient"
	autohost "code.justin.tv/live/autohost/client"

	"code.justin.tv/live/autohost/internal/hosting"
	hosting_logic "code.justin.tv/live/autohost/internal/hosting/logic"
	"github.com/stretchr/testify/require"
)

type testEnv struct {
	client           autohost.Client
	server           *Server
	hostingMockLogic *hosting_logic.MockLogic
}

func newTestEnv(t *testing.T) *testEnv {
	hostingMockLogic := &hosting_logic.MockLogic{}
	hostingComponents, err := hosting.NewHostingComponents(hostingMockLogic)
	require.NoError(t, err)

	server, err := NewServer(hostingComponents)
	require.NoError(t, err)

	httpServer := httptest.NewServer(server)

	client, err := autohost.NewClient(twitchclient.ClientConf{
		Host: httpServer.URL,
	})
	require.NoError(t, err)

	t.Cleanup(func() {
		httpServer.Close()
	})

	return &testEnv{
		client:           client,
		server:           server,
		hostingMockLogic: hostingMockLogic,
	}
}

func getContextWithTimeout() (context.Context, context.CancelFunc) {
	return context.WithTimeout(context.Background(), 5*time.Second)
}
