package api

import (
	"context"
	"net/http"

	autohosterrors "code.justin.tv/live/autohost/internal/errors"
	"code.justin.tv/live/autohost/lib"
)

func (S *Server) getSettings(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	userID, err := getUserIDFromRequestPath(ctx)
	if err != nil {
		S.serveError(w, r, err)
		return
	}

	callerID := r.FormValue(lib.CallerIDKey)
	if callerID == "" {
		S.serveError(w, r, autohosterrors.BadRequest("caller_id is required"))
		return
	}

	settings, err := S.hostingLogic.GetSettings(ctx, callerID, userID)
	if err != nil {
		S.serveError(w, r, err)
		return
	}

	S.serveJSON(w, settings)
}
