package api

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/require"

	"code.justin.tv/live/autohost/lib"
)

func TestGetSettings_Success(t *testing.T) {
	ctx, cancel := getContextWithTimeout()
	defer cancel()

	testEnv := newTestEnv(t)
	hostingMockLogic := testEnv.hostingMockLogic
	client := testEnv.client

	callerID := "11111111"
	userID := callerID
	expectedSettings := &lib.Settings{
		Strategy: lib.AutohostStrategyOrdered,
		Enabled:  false,
		TeamHost: true,
	}
	hostingMockLogic.On("GetSettings", mock.Anything, callerID, userID).Return(expectedSettings, nil).Once()

	returnedSettings, err := client.GetSettings(ctx, callerID, userID, nil)
	require.NoError(t, err)
	require.Equal(t, expectedSettings, returnedSettings)
}

func TestGetSettings_CallerIDRequired(t *testing.T) {
	ctx, cancel := getContextWithTimeout()
	defer cancel()

	testEnv := newTestEnv(t)
	client := testEnv.client

	callerID := ""
	userID := "11111111"

	_, err := client.GetSettings(ctx, callerID, userID, nil)
	require.Error(t, err)
}

func TestGetSettings_ServerError(t *testing.T) {
	ctx, cancel := getContextWithTimeout()
	defer cancel()

	testEnv := newTestEnv(t)
	hostingMockLogic := testEnv.hostingMockLogic
	client := testEnv.client

	callerID := "11111111"
	userID := callerID
	err := fmt.Errorf("a test error")
	hostingMockLogic.On("GetSettings", mock.Anything, callerID, userID).Return(nil, err).Once()

	_, err = client.GetSettings(ctx, callerID, userID, nil)
	require.Error(t, err)
}
