package api

import (
	"fmt"
	"testing"

	"code.justin.tv/live/autohost/lib"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/require"
)

func TestHostTarget_Success(t *testing.T) {
	ctx, cancel := getContextWithTimeout()
	defer cancel()

	testEnv := newTestEnv(t)
	hostingMockLogic := testEnv.hostingMockLogic
	client := testEnv.client

	callerID := "111111111"
	channelID := callerID
	targetID := "22222222"

	hostingMockLogic.On("HostTarget", mock.Anything, callerID, channelID, targetID).Return(nil)

	returnedHost, err := client.HostTarget(ctx, callerID, channelID, targetID, nil)
	require.NoError(t, err)
	require.Equal(t, &lib.Host{
		ChannelID: channelID,
		TargetID:  targetID,
	}, returnedHost)
}

func TestHostTarget_ServerError(t *testing.T) {
	ctx, cancel := getContextWithTimeout()
	defer cancel()

	testEnv := newTestEnv(t)
	hostingMockLogic := testEnv.hostingMockLogic
	client := testEnv.client

	callerID := "111111111"
	channelID := callerID
	targetID := "22222222"
	err := fmt.Errorf("test error")

	hostingMockLogic.On("HostTarget", mock.Anything, callerID, channelID, targetID).Return(err)

	_, err = client.HostTarget(ctx, callerID, channelID, targetID, nil)
	require.Error(t, err)
}
