package api

import (
	"context"
	"net/http"

	"code.justin.tv/live/autohost/lib"
)

func (s *Server) unhost(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	channelID := r.FormValue("channel_id")
	userID := r.FormValue("user_id")
	err := validateUserIDs(map[string]string{
		"channel_id": channelID,
		"user_id":    userID,
	})
	if err != nil {
		s.serveError(w, r, err)
		return
	}

	err = s.hostingLogic.Unhost(ctx, userID, channelID)
	if err != nil {
		s.serveError(w, r, err)
		return
	}

	s.serveJSON(w, lib.Unhost{
		ChannelID: channelID,
	})
}
