package api

import (
	"fmt"
	"testing"

	"code.justin.tv/live/autohost/lib"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/require"
)

func TestUnhost_Success(t *testing.T) {
	ctx, cancel := getContextWithTimeout()
	defer cancel()

	testEnv := newTestEnv(t)
	hostingMockLogic := testEnv.hostingMockLogic
	client := testEnv.client

	callerID := "111111111"
	channelID := callerID
	hostingMockLogic.On("Unhost", mock.Anything, callerID, channelID).Return(nil)

	returnedHost, err := client.Unhost(ctx, callerID, channelID, nil)
	require.NoError(t, err)
	require.Equal(t, &lib.Unhost{
		ChannelID: channelID,
	}, returnedHost)
}

func TestUnhost_ServerError(t *testing.T) {
	ctx, cancel := getContextWithTimeout()
	defer cancel()

	testEnv := newTestEnv(t)
	hostingMockLogic := testEnv.hostingMockLogic
	client := testEnv.client

	callerID := "111111111"
	channelID := callerID
	err := fmt.Errorf("test error")

	hostingMockLogic.On("Unhost", mock.Anything, callerID, channelID).Return(err)

	_, err = client.Unhost(ctx, callerID, channelID, nil)
	require.Error(t, err)
}
