package api

import (
	"fmt"
	"strconv"

	autohosterrors "code.justin.tv/live/autohost/internal/errors"
)

func validateUserIDs(paramToUserID map[string]string) error {
	for paramName, userID := range paramToUserID {
		err := validateUserID(paramName, userID)
		if err != nil {
			return err
		}
	}
	return nil
}

func validateUserID(paramName, userID string) error {
	if userID == "" {
		return autohosterrors.BadRequest(fmt.Sprintf("required param was missing. param=\"%s\"", paramName))
	}

	_, err := strconv.ParseInt(userID, 10, 64)
	if err != nil {
		return autohosterrors.BadRequest(fmt.Sprintf("user ID expected to be numeric. param=\"%s\"", paramName))
	}

	return nil
}
