package dynamo

import (
	"code.justin.tv/creator-collab/log"
	"code.justin.tv/live/autohost/internal/database"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
)

// Params is used to create a Dynamo
type Params struct {
	Client            dynamodbiface.DynamoDBAPI
	Logger            log.Logger
	HostTableName     string
	SettingsTableName string
}

// Dynamo is a domain specific wrapper for the aws client
type Dynamo struct {
	client dynamodbiface.DynamoDBAPI
	logger log.Logger

	HostTableName     string
	settingsTableName string
}

var _ database.Database = &Dynamo{}

// New returns a new Dynamo struct
func New(p Params) *Dynamo {
	return &Dynamo{
		client:            p.Client,
		logger:            p.Logger,
		HostTableName:     p.HostTableName,
		settingsTableName: p.SettingsTableName,
	}
}

// StringSet is []string type that implements the Marshaler interface from
// dynamodbattribute. Using this as an argument to expression.Value will create
// a string set with a single item from the string.
//
// See https://github.com/aws/aws-sdk-go/issues/1990
type StringSet []string

// MarshalDynamoDBAttributeValue implements the Marshaler interface
func (ss StringSet) MarshalDynamoDBAttributeValue(av *dynamodb.AttributeValue) error {
	av.SS = aws.StringSlice(ss)
	return nil
}
