// +build integration

package dynamo_test

import (
	"testing"

	"code.justin.tv/creator-collab/log"
	"code.justin.tv/live/autohost/internal/database/dynamo"
	"code.justin.tv/live/autohost/internal/hosting/storage"
	"code.justin.tv/live/autohost/internal/localdynamo"
	"code.justin.tv/live/autohost/internal/worker/config"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
	"github.com/stretchr/testify/require"
)

type testEnv struct {
	localTables    *localdynamo.Tables
	db             *dynamo.Dynamo
	hostingStorage storage.Storage
	dynamoDBClient dynamodbiface.DynamoDBAPI
}

func newTestEnv(t *testing.T) *testEnv {
	conf, err := config.GetConfig()
	require.NoError(t, err)

	localDynamoEndpoint := conf.DynamoDB.LocalDynamoEndpoint
	require.NotEmpty(t, localDynamoEndpoint)

	logger := log.NewDevelopmentLogger()

	localTables, err := localdynamo.NewLocalDynamoTables(localDynamoEndpoint, logger)
	require.NoError(t, err)

	localDynamoClient, err := localdynamo.NewLocalDynamoDBClient(localDynamoEndpoint)
	require.NoError(t, err)

	db := dynamo.New(dynamo.Params{
		Client:            localDynamoClient,
		Logger:            log.NewDevelopmentLogger(),
		HostTableName:     conf.DynamoDB.HostTableName,
		SettingsTableName: conf.DynamoDB.SettingsTableName,
	})

	hostingStorage := storage.New(&storage.Params{
		Client:            localDynamoClient,
		Logger:            logger,
		HostTableName:     conf.DynamoDB.HostTableName,
		SettingsTableName: conf.DynamoDB.SettingsTableName,
	})

	return &testEnv{
		localTables:    localTables,
		db:             db,
		dynamoDBClient: localDynamoClient,
		hostingStorage: hostingStorage,
	}
}

func (e *testEnv) reset(t *testing.T) {
	err := e.localTables.Reset()
	require.NoError(t, err)
}
