package dynamo

// GetBucketNumber takes a number of buckets to split IDs and an ID. It returns
// partition key.
func GetBucketNumber(partitionSize int, id string) int {
	// As we add and overflow this uint8, the higher bits will be discarded resulting in a
	// number that stays between 0 and 255.
	var total byte
	for _, v := range []byte(id) {
		total += v
	}

	return int(total) % partitionSize
}
