package dynamo_test

import (
	"fmt"
	"testing"

	"code.justin.tv/live/autohost/internal/database/dynamo"
	"github.com/stretchr/testify/assert"
)

func TestGetBucketNumberTest(t *testing.T) {
	var tests = []struct {
		bucketCount int
		id          string
		expected    int
	}{
		{1, "0", 0},
		{1, "1", 0},
		{1, "1234", 0},
		{2, "0", 0},
		{2, "1", 1},
		{2, "2", 0},
		{2, "abc", 0},
		{2, "abd", 1},
	}

	for _, tt := range tests {
		testName := fmt.Sprintf("bucketCount: %d, id: %s", tt.bucketCount, tt.id)
		t.Run(testName, func(t *testing.T) {
			assert.Equal(t, dynamo.GetBucketNumber(tt.bucketCount, tt.id), tt.expected)
		})
	}
}
