// +build integration

package dynamo_test

import (
	"context"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestCacheLiveUsers(t *testing.T) {
	testEnv := newTestEnv(t)
	db := testEnv.db

	t.Run("saving and getting all live channelIDs", func(t *testing.T) {
		testEnv.reset(t)

		channelInput := map[string]bool{
			"123456789": true,
			"234567891": true,
			"345678912": true,
		}

		err := db.CacheLiveUsers(context.Background(), channelInput)
		require.NoError(t, err)

		savedChannels, err := db.GetCachedLiveUsers(context.Background())
		require.NoError(t, err)
		require.Equal(t, channelInput, savedChannels)
	})

	t.Run("getting when there is no existing cache data", func(t *testing.T) {
		testEnv.reset(t)

		savedChannels, err := db.GetCachedLiveUsers(context.Background())
		require.NoError(t, err)
		require.Equal(t, map[string]bool{}, savedChannels)
	})

	t.Run("overwriting existing cache data", func(t *testing.T) {
		testEnv.reset(t)

		channelInput1 := map[string]bool{
			"123456789": true,
		}
		err := db.CacheLiveUsers(context.Background(), channelInput1)
		require.NoError(t, err)

		channelInput2 := map[string]bool{
			"234567890": true,
		}
		err = db.CacheLiveUsers(context.Background(), channelInput2)
		require.NoError(t, err)

		savedChannels, err := db.GetCachedLiveUsers(context.Background())
		require.NoError(t, err)
		require.Equal(t, channelInput2, savedChannels)
	})
}
