package clue

import "context"

func NewNoopClient() Client {
	return &noopClient{}
}

var _ Client = &noopClient{}

type noopClient struct{}

func (n *noopClient) GetHost(ctx context.Context, channelIDs []string) (map[string]string, error) {
	return nil, nil
}

func (n *noopClient) GetHosters(ctx context.Context, channelID string) ([]string, error) {
	return nil, nil
}

func (n *noopClient) Host(ctx context.Context, channelID, targetID string, isAutohost bool, isPostRaidHost bool) error {
	return nil
}

func (n *noopClient) Unhost(ctx context.Context, channelID string) error {
	return nil
}
