package recs

import (
	"context"
	"sync"

	twitchrecs "code.justin.tv/amzn/TwitchRecsTwirp"
	"code.justin.tv/live/autohost/rpc/hosting"
)

type StubClient struct {
	recommendedChannelsResults []*twitchrecs.RecommendedItem
	recommendedChannelsError   error
	mutex                      sync.Mutex
}

var _ Client = &StubClient{}

func NewStubClient() *StubClient {
	return &StubClient{}
}

func (s *StubClient) SetResultsForGetRecommendedChannels(results []*twitchrecs.RecommendedItem) {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	s.recommendedChannelsResults = results
}

func (s *StubClient) SetErrorResultForGetRecommendedChannels(err error) {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	s.recommendedChannelsError = err
}

func (s *StubClient) GetProductID() string {
	return "stub"
}

func (s *StubClient) GetRecommendedChannels(ctx context.Context, userContext *hosting.UserContext, channelFilter []string, limit int64) ([]*twitchrecs.RecommendedItem, string, error) {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	if s.recommendedChannelsError != nil {
		return nil, "", s.recommendedChannelsError
	}

	return s.recommendedChannelsResults, "", nil
}
