package spade

import (
	"bytes"
	"errors"
	"fmt"

	"code.justin.tv/creator-collab/log"
	"code.justin.tv/hygienic/spade"
)

type spadeLogger struct {
	logger log.Logger
}

// SpadeLogger implements the spade.Logger interface.
var _ spade.Logger = &spadeLogger{}

// The spade log interface doesn't define an interface that separates error objects, messages and fields.
// This log method will essentially combine all values with a space in between and log that as an error.
// It's not ideal, but we would need a better interface from spade to do better.
func (t *spadeLogger) Log(vals ...interface{}) {
	if len(vals) == 0 {
		return
	}

	t.logger.Error(errors.New(createErrorString(vals)))
}

func createErrorString(vals ...interface{}) string {
	if len(vals) == 0 {
		return ""
	}

	var buffer bytes.Buffer
	for i, val := range vals {
		if i == 0 {
			buffer.WriteString(fmt.Sprintf("%v", val))
		} else {
			buffer.WriteString(fmt.Sprintf(" %v", val))
		}
	}

	return buffer.String()
}
