package spade

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestSpadeLoggerStringGenerator(t *testing.T) {
	t.Run("single argument string", func(t *testing.T) {
		str := createErrorString("this is a message")
		require.Equal(t, "this is a message", str)
	})

	t.Run("multiple arguments string", func(t *testing.T) {
		str := createErrorString("this", "is", "a", "message")
		require.Equal(t, "this is a message", str)
	})

	t.Run("single argument error", func(t *testing.T) {
		str := createErrorString(errors.New("this is an error object"))
		require.Equal(t, "this is an error object", str)
	})

	t.Run("multiple arguments with error", func(t *testing.T) {
		str := createErrorString("this", "is an", errors.New("error object"), "i created")
		require.Equal(t, "this is an error object i created", str)
	})

	t.Run("multiple errors", func(t *testing.T) {
		str := createErrorString(errors.New("this is an"), errors.New("error object"), "-", 1001)
		require.Equal(t, "this is an error object - 1001", str)
	})

	t.Run("no arguments", func(t *testing.T) {
		str := createErrorString()
		require.Equal(t, "", str)
	})
}
