package spade

import (
	"sync"

	"code.justin.tv/hygienic/spade"
)

type StubClient struct {
	sentEvents                []spade.Event
	lastEndorsedChannelsEvent []InsertedRecommendationTrackingProperties
	mutex                     sync.Mutex
}

var _ Client = &StubClient{}

func NewStubClient() *StubClient {
	return &StubClient{
		sentEvents: []spade.Event{},
	}
}

func (s *StubClient) ClearEvents() {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	s.sentEvents = []spade.Event{}
	s.lastEndorsedChannelsEvent = nil
}

func (s *StubClient) GetNumberInsertRecommendationEvents() int {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	return len(s.lastEndorsedChannelsEvent)
}

func (s *StubClient) GetSentEvents() []spade.Event {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	return s.sentEvents
}

func (s *StubClient) GetInsertedRecommendationTrackingItems() []InsertedRecommendationTrackingProperties {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	return s.lastEndorsedChannelsEvent
}

func (s *StubClient) QueueEvent(event string, properties interface{}) {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	s.sentEvents = append(s.sentEvents, spade.Event{
		Name:       event,
		Properties: properties,
	})
}

func (s *StubClient) QueueEvents(events ...spade.Event) {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	s.sentEvents = append(s.sentEvents, events...)
}

func (s *StubClient) QueueInsertedRecommendationEvents(productID string, items ...InsertedRecommendationTrackingProperties) {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	s.lastEndorsedChannelsEvent = append(s.lastEndorsedChannelsEvent, items...)
}
