package users

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/web/users-service/models"
)

func NewNoopClient() Client {
	return &noopClient{}
}

var _ Client = &noopClient{}

type noopClient struct{}

func (n noopClient) GetUserByID(ctx context.Context, userID string, reqOpts *twitchclient.ReqOpts) (*models.Properties, error) {
	return nil, nil
}
