package eventbus

import (
	"context"

	"code.justin.tv/creator-collab/log/errors"
	"code.justin.tv/eventbus/client/publisher"
	"code.justin.tv/eventbus/schema/pkg/channel_endorsement_list"
	"github.com/aws/aws-sdk-go/aws/client"
)

type Publisher interface {
	ChannelEndorsementListUpdate(ctx context.Context, m *channel_endorsement_list.ChannelEndorsementListUpdate) error
}

type impl struct {
	*publisher.Publisher
}

func (i impl) ChannelEndorsementListUpdate(ctx context.Context, m *channel_endorsement_list.ChannelEndorsementListUpdate) error {
	return i.Publish(ctx, m)
}

func NewPublisher(env publisher.Environment, sess client.ConfigProvider) (Publisher, error) {
	p, err := publisher.New(publisher.Config{
		Environment: env,
		Session:     sess,
		EventTypes:  []string{channel_endorsement_list.UpdateEventType},
	})

	if err != nil {
		return nil, errors.Wrap(err, "could not init eventbus publisher client")
	}

	return impl{p}, nil
}

type noopImpl struct{}

func (n noopImpl) ChannelEndorsementListUpdate(ctx context.Context, m *channel_endorsement_list.ChannelEndorsementListUpdate) error {
	return nil
}

// NewNoopPublisher return a noop publisher that does nothing.
func NewNoopPublisher() Publisher {
	return &noopImpl{}
}
