package logic

import (
	"fmt"

	"code.justin.tv/creator-collab/log"
)

func newAccessLogger(logger log.Logger) *accessLogger {
	return &accessLogger{
		logger: logger,
	}
}

type accessLogger struct {
	logger log.Logger
}

func (a *accessLogger) Log(operationName string, err error, fields ...log.Fields) {
	errStr := ""
	if err != nil {
		errStr = err.Error()
	}

	allFields := []log.Fields{
		{
			"type":      "operation_access_log",
			"operation": operationName,
			"success":   err == nil,
			"error":     errStr,
		},
	}
	allFields = append(allFields, fields...)

	msg := fmt.Sprintf("%s access log", operationName)
	a.logger.Debug(msg, allFields...)
}
