package logic

import (
	"strconv"

	"code.justin.tv/creator-collab/log/errors"

	"code.justin.tv/live/autohost/lib"
)

type settingsTrackingEvent struct {
	UserID              int                  `json:"user_id"`
	AutohostEnabled     bool                 `json:"autohost_enabled"`
	TeamHost            bool                 `json:"team_host"`
	AutohostStrategy    lib.AutohostStrategy `json:"autohost_strategy"`
	DeprioritizeVodcast bool                 `json:"deprioritize_vodcast"`
	CanBeRaidedBy       lib.CanBeRaidedBy    `json:"can_be_raided_by"`
}

func (T *Impl) trackSettings(userID string, settings *lib.Settings) error {
	user, err := strconv.Atoi(userID)
	if err != nil {
		return errors.Wrap(err, "could not convert user ID to int", errors.Fields{
			"userID": userID,
		})
	}

	T.tracking.QueueEvent("host_settings_change", settingsTrackingEvent{
		UserID:              user,
		AutohostEnabled:     settings.Enabled,
		TeamHost:            settings.TeamHost,
		AutohostStrategy:    settings.Strategy,
		DeprioritizeVodcast: settings.DeprioritizeVodcast,
		CanBeRaidedBy:       settings.CanBeRaidedBy,
	})
	return nil
}
