package logic

import (
	"context"
)

// GetList gets a list
func (T *Impl) GetList(ctx context.Context, user string) ([]string, error) {
	// Check if a cached list exists. If so, use that value.
	cachedList, found, err := T.cache.GetList(ctx, user)
	if err != nil {
		T.logger.Error(err)
	}

	if found {
		return cachedList, nil
	}

	// If the value isn't in the cache, retrieve from the database and save to cache
	list, err := T.db.GetList(ctx, user)
	if err != nil {
		return nil, err
	}

	err = T.cache.SetList(ctx, user, list)
	if err != nil {
		T.logger.Error(err)
	}

	return list, nil
}
