package redis

import "context"

// Returns a stub rate limiter that allows all operations.
func NewRateLimiterStub(allow bool) *RateLimiterStub {
	return &RateLimiterStub{
		allow: allow,
	}
}

type RateLimiterStub struct {
	allow bool
}

// RateLimiterStub implements the RateLimiter interface.
var _ RateLimiter = &RateLimiterStub{}

func (r *RateLimiterStub) RateLimitHostBySourceID(_ context.Context, _ string) bool {
	return r.allow
}

func (r *RateLimiterStub) RateLimitUnhostBySourceID(_ context.Context, _ string) bool {
	return r.allow
}
