package server

import (
	"context"

	autohosterrors "code.justin.tv/live/autohost/internal/errors"
	"github.com/twitchtv/twirp"

	"code.justin.tv/live/autohost/rpc/hosting"
)

func (h *TwirpHandlers) AddToAutohostList(ctx context.Context, request *hosting.AddToAutohostListRequest) (*hosting.AddToAutohostListResponse, error) {
	if request == nil {
		return nil, twirp.RequiredArgumentError("AddToAutohostListRequest")
	}
	callerID := request.CallerId
	if callerID == "" {
		return nil, twirp.RequiredArgumentError("CallerId")
	}
	sourceID := request.SourceId
	if sourceID == "" {
		return nil, twirp.RequiredArgumentError("SourceId")
	}
	targetIDsToAdd := request.TargetIdsToAdd
	if len(targetIDsToAdd) == 0 {
		return nil, twirp.InvalidArgumentError("TargetIdsToAdd", "TargetIdsToAdd should not be empty")
	}

	updatedList, err := h.Logic.AddList(ctx, callerID, sourceID, targetIDsToAdd)
	if err != nil {
		return nil, autohosterrors.GetTwirpErr(err)
	}

	return &hosting.AddToAutohostListResponse{
		TargetIds: updatedList,
	}, nil
}
