package server

import (
	"testing"

	"code.justin.tv/live/autohost/lib"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/golang/protobuf/ptypes/wrappers"
	"github.com/stretchr/testify/require"
	"github.com/twitchtv/twirp"

	"code.justin.tv/live/autohost/rpc/hosting"
)

func TestConvertUpdateAutohostSettingsRequest_Enabled(t *testing.T) {
	actual, err := convertUpdateAutohostSettingsRequest(&hosting.UpdateAutohostSettingsRequest{
		CallerId: "111111111",
		UserId:   "222222222",
		Enabled: &wrappers.BoolValue{
			Value: true,
		},
	})

	expected := &lib.UpdateSettingsInput{
		Enabled: aws.Bool(true),
	}
	require.NoError(t, err)
	require.Equal(t, expected, actual)
}

func TestConvertUpdateAutohostSettingsRequest_TeamHost(t *testing.T) {
	actual, err := convertUpdateAutohostSettingsRequest(&hosting.UpdateAutohostSettingsRequest{
		CallerId: "111111111",
		UserId:   "222222222",
		TeamHost: &wrappers.BoolValue{
			Value: true,
		},
	})

	expected := &lib.UpdateSettingsInput{
		TeamHost: aws.Bool(true),
	}
	require.NoError(t, err)
	require.Equal(t, expected, actual)
}

func TestConvertUpdateAutohostSettingsRequest_DeprioritizeVodcast(t *testing.T) {
	actual, err := convertUpdateAutohostSettingsRequest(&hosting.UpdateAutohostSettingsRequest{
		CallerId: "111111111",
		UserId:   "222222222",
		DeprioritizeVodcast: &wrappers.BoolValue{
			Value: true,
		},
	})

	expected := &lib.UpdateSettingsInput{
		DeprioritizeVodcast: aws.Bool(true),
	}
	require.NoError(t, err)
	require.Equal(t, expected, actual)
}

func TestConvertUpdateAutohostSettingsRequest_Strategy(t *testing.T) {
	actual, err := convertUpdateAutohostSettingsRequest(&hosting.UpdateAutohostSettingsRequest{
		CallerId: "111111111",
		UserId:   "222222222",
		Strategy: hosting.AutohostStrategy_AUTOHOST_STRATEGY_RANDOM,
	})
	strategy := lib.AutohostStrategyRandom
	expected := &lib.UpdateSettingsInput{
		Strategy: &strategy,
	}
	require.NoError(t, err)
	require.Equal(t, expected, actual)
}

func TestConvertUpdateAutohostSettingsRequest_BadStrategy(t *testing.T) {
	actual, err := convertUpdateAutohostSettingsRequest(&hosting.UpdateAutohostSettingsRequest{
		CallerId: "111111111",
		UserId:   "222222222",
		Strategy: hosting.AutohostStrategy(100),
	})
	requireTwirpError(t, twirp.InvalidArgument, err)
	require.Nil(t, actual)
}
