package server

import (
	"context"

	autohosterrors "code.justin.tv/live/autohost/internal/errors"
	"code.justin.tv/live/autohost/rpc/hosting"
	"github.com/twitchtv/twirp"
)

func (h *TwirpHandlers) GetAutohostList(ctx context.Context, req *hosting.GetAutohostListRequest) (*hosting.GetAutohostListResponse, error) {
	sourceID := req.GetSourceId()

	if sourceID == "" {
		return nil, twirp.NewError(twirp.InvalidArgument, "source_id is required.")
	}

	ids, err := h.Logic.GetList(ctx, sourceID)
	if err != nil {
		return nil, autohosterrors.GetTwirpErr(err)
	}

	return &hosting.GetAutohostListResponse{TargetIds: ids}, nil
}
