package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/live/autohost/internal/hosting/logic"
	"code.justin.tv/live/autohost/rpc/hosting"
	"github.com/stretchr/testify/require"
)

func TestGetAutohostList(t *testing.T) {
	sourceID := "1234"
	req := &hosting.GetAutohostListRequest{SourceId: sourceID}

	ctx := context.Background()
	mockLogic := &logic.MockLogic{}
	handlers := NewTwirpHandlers(mockLogic)

	t.Run("returns an error on failure", func(t *testing.T) {
		mockLogic.On("GetList", ctx, sourceID).Return(nil, errors.New("err")).Once()
		res, err := handlers.GetAutohostList(ctx, req)

		require.Nil(t, res)
		require.Error(t, err)
	})

	t.Run("returns response on success", func(t *testing.T) {
		mockLogic.On("GetList", ctx, sourceID).Return([]string{"1"}, nil).Once()
		res, err := handlers.GetAutohostList(ctx, req)

		require.NotNil(t, res)
		require.NoError(t, err)
		require.Equal(t, res.TargetIds, []string{"1"})
	})
}
