package server

import (
	"context"

	autohosterrors "code.justin.tv/live/autohost/internal/errors"
	"code.justin.tv/live/autohost/rpc/hosting"
	"github.com/twitchtv/twirp"
)

func (h *TwirpHandlers) GetAutohostSettings(
	ctx context.Context,
	request *hosting.GetAutohostSettingsRequest) (*hosting.GetAutohostSettingsResponse, error) {

	if request == nil {
		return nil, twirp.RequiredArgumentError("GetAutohostSettingsRequest")
	}
	callerID := request.CallerId
	if callerID == "" {
		return nil, twirp.RequiredArgumentError("CallerId")
	}
	userID := request.UserId
	if userID == "" {
		return nil, twirp.RequiredArgumentError("UserId")
	}

	settings, err := h.Logic.GetSettings(ctx, callerID, userID)
	if err != nil {
		return nil, autohosterrors.GetTwirpErr(err)
	}
	twirpSettings, err := convertSettings(settings)
	if err != nil {
		return nil, autohosterrors.GetTwirpErr(err)
	}

	return &hosting.GetAutohostSettingsResponse{
		Settings: twirpSettings,
	}, nil
}
