package server

import (
	"context"

	autohosterrors "code.justin.tv/live/autohost/internal/errors"
	"code.justin.tv/live/autohost/rpc/hosting"
	"github.com/twitchtv/twirp"
)

func (h *TwirpHandlers) GetEndorsedChannels(ctx context.Context, req *hosting.GetEndorsedChannelsRequest) (*hosting.GetEndorsedChannelsResponse, error) {
	targetChannelID := req.TargetChannelId
	if targetChannelID == "" {
		return nil, twirp.RequiredArgumentError("TargetChannelID")
	}

	channels, err := h.Logic.GetEndorsedChannels(ctx, req.GetUserContext(), targetChannelID, int(req.GetLimit()))
	if err != nil {
		return nil, autohosterrors.GetTwirpErr(err)
	}

	return &hosting.GetEndorsedChannelsResponse{
		EndorsedChannels: channels,
	}, nil
}
