package server

import (
	"context"

	autohosterrors "code.justin.tv/live/autohost/internal/errors"
	"github.com/twitchtv/twirp"

	"code.justin.tv/live/autohost/rpc/hosting"
)

func (h *TwirpHandlers) RemoveFromAutohostList(ctx context.Context, request *hosting.RemoveFromAutohostListRequest) (*hosting.RemoveFromAutohostListResponse, error) {
	if request == nil {
		return nil, twirp.RequiredArgumentError("RemoveFromAutohostListRequest")
	}
	callerID := request.CallerId
	if callerID == "" {
		return nil, twirp.RequiredArgumentError("CallerId")
	}
	sourceID := request.SourceId
	if sourceID == "" {
		return nil, twirp.RequiredArgumentError("SourceId")
	}
	targetIDsToRemove := request.TargetIdsToRemove
	if len(targetIDsToRemove) == 0 {
		return nil, twirp.InvalidArgumentError("TargetIdsToRemove", "TargetIdsToRemove should not be empty")
	}

	updatedList, err := h.Logic.RemoveList(ctx, callerID, sourceID, targetIDsToRemove)
	if err != nil {
		return nil, autohosterrors.GetTwirpErr(err)
	}

	return &hosting.RemoveFromAutohostListResponse{
		TargetIds: updatedList,
	}, nil
}
