package server

import (
	"context"

	autohosterrors "code.justin.tv/live/autohost/internal/errors"
	"github.com/twitchtv/twirp"

	"code.justin.tv/live/autohost/rpc/hosting"
)

func (h *TwirpHandlers) SetAutohostList(ctx context.Context, request *hosting.SetAutohostListRequest) (*hosting.SetAutohostListResponse, error) {
	if request == nil {
		return nil, twirp.RequiredArgumentError("SetAutohostListRequest")
	}
	callerID := request.CallerId
	if callerID == "" {
		return nil, twirp.RequiredArgumentError("CallerId")
	}
	sourceID := request.SourceId
	if sourceID == "" {
		return nil, twirp.RequiredArgumentError("SourceId")
	}

	targetIDs := request.TargetIds
	if targetIDs == nil {
		targetIDs = make([]string, 0)
	}

	updatedList, err := h.Logic.SetList(ctx, callerID, sourceID, targetIDs)
	if err != nil {
		return nil, autohosterrors.GetTwirpErr(err)
	}

	return &hosting.SetAutohostListResponse{
		TargetIds: updatedList,
	}, nil
}
