package server

import (
	"context"

	autohosterrors "code.justin.tv/live/autohost/internal/errors"
	"github.com/twitchtv/twirp"

	"code.justin.tv/live/autohost/rpc/hosting"
)

func (h *TwirpHandlers) UpdateAutohostSettings(ctx context.Context, request *hosting.UpdateAutohostSettingsRequest) (*hosting.UpdateAutohostSettingsResponse, error) {
	if request == nil {
		return nil, twirp.RequiredArgumentError("UpdateAutohostSettingsRequest")
	}
	callerID := request.CallerId
	if callerID == "" {
		return nil, twirp.RequiredArgumentError("CallerId")
	}
	userID := request.UserId
	if userID == "" {
		return nil, twirp.RequiredArgumentError("UserId")
	}

	updateSettingsInput, err := convertUpdateAutohostSettingsRequest(request)
	if err != nil {
		return nil, err
	}

	settings, err := h.Logic.UpdateSettings(ctx, callerID, userID, updateSettingsInput)
	if err != nil {
		return nil, autohosterrors.GetTwirpErr(err)
	}

	twirpSettings, err := convertSettings(settings)
	if err != nil {
		return nil, err
	}

	return &hosting.UpdateAutohostSettingsResponse{
		Settings: twirpSettings,
	}, nil
}
