package stringslice

import (
	"sort"
)

func ContainsSameElements(s1, s2 []string) bool {
	if len(s1) != len(s2) {
		return false
	}

	s1 = Copy(s1)
	s2 = Copy(s2)
	sort.StringSlice(s1).Sort()
	sort.StringSlice(s2).Sort()

	for i := 0; i < len(s1); i++ {
		if s1[i] != s2[i] {
			return false
		}
	}

	return true
}

func Copy(s []string) []string {
	result := make([]string, 0, len(s))
	result = append(result, s...)
	return result
}

func Concat(lists ...[]string) []string {
	result := make([]string, 0)
	for _, l := range lists {
		result = append(result, l...)
	}
	return result
}

func Contains(slice []string, value string) bool {
	for _, s := range slice {
		if s == value {
			return true
		}
	}
	return false
}

func ToSet(slice []string) map[string]bool {
	set := make(map[string]bool, len(slice))
	for _, s := range slice {
		set[s] = true
	}
	return set
}

func Truncate(slice []string, maxLength int) []string {
	if maxLength >= len(slice) {
		return slice
	}
	return slice[:maxLength]
}
