// Package logfield contains common fields that can be added to log events and errors.
// Using consistent field names makes it easier to filter and correlate log events.
package logfield

const (
	// RaidID points to the ID of a raid.
	RaidID = "raid_id"

	// RaidParticipantDeviceID points to the device ID of a user that participates in a raid.
	RaidParticipantDeviceID = "participant_device_id"

	// RaidParticipantUserID points to the ID of a user that participates in a raid.
	RaidParticipantUserID = "participant_user_id"

	// RaidSourceChannelID points to the ID of the channel that the raid is starting from.
	RaidSourceChannelID = "source_id"

	// RaidCallerChannelID points to the ID of the channel that created the raid request.
	RaidCallerChannelID = "caller_id"

	// RaidTargetChannelID points to the ID of the channel that is getting raided.
	RaidTargetChannelID = "target_id"

	// RaidParticipantCount is the number of users that joined the raid.
	RaidParticipantCount = "participant_count"
)

const (
	// HostCallerChannelID points to the ID of the channel that created the hosting request.
	HostCallerChannelID = "caller_id"

	// HosterChannelID points the channel that plays the other channel's video.
	HosterChannelID = "hoster_id"

	// HostTargetChannelID points to the channel whose live video gets played on the hoster's channel.
	HostTargetChannelID = "host_target_id"

	// HostTargetChannelIDs points to the channels whose live video gets played on a hoster's channel.
	HostTargetChannelIDs = "host_target_ids"
)

const (
	// ChannelID points to a channel.
	ChannelID = "user_id"

	// TeamID points to a team.
	TeamID = "team_id"

	// UserID points to a user.
	UserID = "user_id"

	// The target channel for the operation
	TargetID = "target_id"

	// UserLogins points to a collection of logins.
	UserLogins = "logins"

	// HTTPStatusCode points to the status code of an HTTP response.
	HTTPStatusCode = "http_status_code"
)
