package logging

import (
	"net/http"
	"testing"

	"code.justin.tv/creator-collab/log"
)

// ErrorLogger is an interface for RollbarErrorLogger
type ErrorLogger interface {
	Error(err error)
	RequestError(r *http.Request, err error)
}

// CollabLogErrorLogger logs error to Rollbar and to standard error.
type CollabLogErrorLogger struct {
	Logger log.Logger
}

// Error reports an error
func (c *CollabLogErrorLogger) Error(err error) {
	c.Logger.Error(err)
}

// RequestError reports an error
func (c *CollabLogErrorLogger) RequestError(_ *http.Request, err error) {
	c.Logger.Error(err)
}

// FailTestErrorLogger is a logger that fails tests on error.
type FailTestErrorLogger struct {
	t *testing.T
}

// NewFailTestErrorLogger is a constructor
func NewFailTestErrorLogger(t *testing.T) *FailTestErrorLogger {
	return &FailTestErrorLogger{t}
}

// Error reports and error and fails the current test.
func (l *FailTestErrorLogger) Error(err error) {
	l.t.Fatalf("ErrorLogger reported: %+v", err)
}

// RequestError reports a RequestError and fails the current test.
func (l *FailTestErrorLogger) RequestError(_ *http.Request, err error) {
	l.t.Fatalf("ErrorLogger reported request error: %+v", err)
}
