package logging

import (
	"fmt"
	"time"

	logging "code.justin.tv/amzn/TwitchLogging"
	"code.justin.tv/creator-collab/log"
)

// TwitchLogger implements the Logger interface that fulton related packages use.
type TwitchLogger struct {
	Logger log.Logger
}

// TwitchLogger implements the logging.Logger interface.
var _ logging.Logger = &TwitchLogger{}

func (t *TwitchLogger) Log(msg string, keyVals ...interface{}) {
	t.Logger.Log(&log.LogEvent{
		Message: msg,
		Level:   log.LevelError,
		Time:    time.Now().UTC(),
		Fields:  convertKeyValuesToFields(keyVals),
	})
}

func convertKeyValuesToFields(keyVals []interface{}) log.Fields {
	fields := log.Fields{}

	var key string
	for i, keyVal := range keyVals {
		if i%2 == 0 {
			key = fmt.Sprintf("%v", keyVal)
		} else {
			fields[key] = keyVal
		}
	}

	return fields
}
